/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import jtbcore.exception.InvalidStateException;

public class ImageUtil {
    public static byte[] img2jpg(BufferedImage img, int q) throws IOException {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (ImageOutputStream ios = ImageIO.createImageOutputStream(baos);){
                writer.setOutput(ios);
                ImageWriteParam param = writer.getDefaultWriteParam();
                param.setCompressionMode(2);
                param.setCompressionQuality((float)q / 100.0f);
                writer.write(img);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            writer.dispose();
        }
        return baos.toByteArray();
    }

    public static void write2jpg(BufferedImage img, int q, File f) throws IOException {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (ImageOutputStream ios = ImageIO.createImageOutputStream(os);){
                writer.setOutput(ios);
                ImageWriteParam param = writer.getDefaultWriteParam();
                param.setCompressionMode(2);
                param.setCompressionQuality((float)q / 100.0f);
                writer.write(img);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            writer.dispose();
            if (os != null) {
                os.close();
            }
        }
    }

    public static byte[] img2png(BufferedImage img) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", baos);
        return baos.toByteArray();
    }

    public static void write2png(BufferedImage img, File f) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
        ImageIO.write((RenderedImage)img, "png", os);
        os.close();
    }

    public static BufferedImage image2threshold(File f, int threshold) throws IOException, InvalidStateException {
        if (threshold < 0 || threshold > 255) {
            throw new InvalidStateException("Invalid threshold");
        }
        BufferedImage originalImage = ImageIO.read(f);
        BufferedImage thresholdedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 12);
        Graphics2D g2d = (Graphics2D)thresholdedImage.getGraphics();
        int oih = originalImage.getHeight();
        int oiw = originalImage.getWidth();
        int[] test = originalImage.getRGB(0, 0, oiw, oih, null, 0, oiw);
        int y = 0;
        while (y < oih) {
            int x = 0;
            while (x < oiw) {
                int rgb = test[oiw * y + x];
                int red = rgb & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb >> 16 & 0xFF;
                int gray = (red + green + blue) / 3;
                if (gray > threshold) {
                    g2d.setColor(Color.WHITE);
                } else {
                    g2d.setColor(Color.BLACK);
                }
                g2d.drawLine(x, y, x, y);
                ++x;
            }
            ++y;
        }
        return thresholdedImage;
    }

    public static BufferedImage resize(BufferedImage img, int targetWidth, int targetHeight) {
        int newHeight;
        int newWidth;
        double f2;
        if (img.getWidth() == targetWidth && img.getHeight() == targetHeight) {
            return img;
        }
        double f1 = (double)img.getWidth() / (double)img.getHeight();
        if (f1 > (f2 = (double)targetWidth / (double)targetHeight)) {
            newWidth = targetWidth;
            newHeight = (int)((double)img.getHeight() * (double)targetWidth / (double)img.getWidth());
        } else {
            newHeight = targetHeight;
            newWidth = (int)((double)img.getWidth() * (double)targetHeight / (double)img.getHeight());
        }
        BufferedImage resizedImage = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D graphics2D = resizedImage.createGraphics();
        graphics2D.setColor(new Color(255, 255, 255));
        graphics2D.fillRect(0, 0, newWidth, newHeight);
        graphics2D.drawImage(img.getScaledInstance(newWidth, newHeight, 16), 0, 0, null);
        graphics2D.dispose();
        return resizedImage;
    }

    public static void writeAsJpegToOutputStream(BufferedImage img, float quality, OutputStream os) throws IOException {
        ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
        jpgWriter.setOutput(ios);
        ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
        jpgWriteParam.setCompressionMode(2);
        jpgWriteParam.setCompressionQuality(quality);
        jpgWriter.write(null, new IIOImage(img, null, null), jpgWriteParam);
        ios.close();
        os.flush();
        os.close();
        jpgWriter.dispose();
    }
}

